/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.ui.UIPropertyChangeSupport;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.config.ResourcesNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.WorkareaConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.ResourceMutableTreeNode;
import com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet;
import java.beans.PropertyChangeEvent;
import java.util.Set;

public final class ResourceRootTreeNode
extends ResourceMutableTreeNode {
    private static final String TRACEMASK_T = "XBUIRRNT";
    private static final String TRACEMASK_F = "XBUIRRNF";
    private static final String TRACEMASK_D = "XBUIRRND";

    protected ResourceRootTreeNode(ResourceRootTreeNode clonee, BonsaiTreeNode parent) {
        this(clonee, parent, clonee.getXMLKey());
    }

    protected ResourceRootTreeNode(ResourceRootTreeNode clonee, BonsaiTreeNode parent, String idPostfix) {
        super(clonee, parent, idPostfix);
    }

    public ResourceRootTreeNode(ResourcesNodeConfigBean configBean, Set rootObjectTypes, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters) {
        this(configBean, rootObjectTypes, parent, defaultWorkarea, filters, configBean.getKey());
    }

    public ResourceRootTreeNode(ResourcesNodeConfigBean configBean, Set rootObjectTypes, BonsaiTreeNode parent, WorkareaConfigBean defaultWorkarea, Set filters, String idPostfix) {
        super(configBean, parent, defaultWorkarea, filters, idPostfix);
        this.setListener(new RootTreeNodeListener(rootObjectTypes));
    }

    public BonsaiTreeNode getCopy(BonsaiTreeNode parent, boolean copyChildren) {
        ResourceRootTreeNode node = new ResourceRootTreeNode(this, parent);
        if (copyChildren) {
            node.copyChildren(this);
        }
        return node;
    }

    private class RootTreeNodeListener
    extends ResourceMutableTreeNode.AbstractTreeNodeListener {
        private Set rootObjectTypes;

        private RootTreeNodeListener(Set rootObjectTypes) {
            super(ResourceRootTreeNode.this);
            this.rootObjectTypes = rootObjectTypes;
        }

        protected synchronized void register() {
            UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport().addRootPropertyChangeListener(this);
        }

        protected synchronized void deregister() {
            UIPropertyChangeSupport registry = UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport();
            registry.removeRootPropertyChangeListener(this);
            registry.removeInventoryListener(this);
        }

        public synchronized void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            Trace.trace(ResourceRootTreeNode.TRACEMASK_F, "--> ResourceRootTreeNode.propertyChange(" + propertyName + ") [node='" + this.getOwner().getId() + "']");
            if (propertyName.equals("InventoryProperty")) {
                Trace.trace(ResourceRootTreeNode.TRACEMASK_F, "property change for inventory - rebuilding this branch (" + this.getOwner().getId() + ")");
                try {
                    BonsaiTreeManager.getBonsaiTreeManager().rebuildBranch(this.getOwner());
                    UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport().removeInventoryListener(this);
                }
                catch (InvalidIdException iiEx) {}
            } else {
                byte[] props = ControllerServlet.getUIObjectsReader().getBuffer((String)event.getSource(), true);
                if (this.rootObjectTypes.contains(new Byte(UIObjectProperties.getType(props)))) {
                    Trace.trace(ResourceRootTreeNode.TRACEMASK_F, "property change for root object - rebuilding this branch (" + this.getOwner().getId() + ")");
                    try {
                        BonsaiTreeManager.getBonsaiTreeManager().rebuildBranch(this.getOwner());
                    }
                    catch (InvalidIdException iiEx) {
                        UIObjectsWriter.getUIObjectsWriter().getUIPropertyChangeSupport().addInventoryListener(this);
                    }
                }
            }
            Trace.trace(ResourceRootTreeNode.TRACEMASK_F, "<-- ResourceRootTreeNode.propertyChange()");
        }
    }
}

